package com.ejie.ab04b.validation;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.exception.ErrorField;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.ComunicacionPrl;
import com.ejie.ab04b.model.DatosAviso;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.service.ComunicacionAperturaService;
import com.ejie.ab04b.service.ComunicacionPrlService;
import com.ejie.ab04b.service.DatosAvisoService;
import com.ejie.ab04b.util.Utilities;

/**
 * Clase encargada de las validaciones para denuncias temporales
 * 
 * @author GFI-NORTE
 */
@Component()
public final class ComunicacionPrlValidator extends
		AbstractPRLValidator<ComunicacionPrl> {

	@Autowired()
	private DatosAvisoService datosAvisoService;
	@Autowired()
	private ComunicacionAperturaService comunicacionAperturaService;
	
	@Autowired()
	private ComunicacionPrlService comunicionPrlService;

	/**
	 * Method 'DenunciaValidator'.
	 */
	private ComunicacionPrlValidator() {
		super();
	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields
	 *            List<ErrorField>
	 *  comunicacionPrl
	 *            ComunicacionPrl
	 *
	 * @param errorFields the error fields
	 * @param comunicacionPrl the comunicacion prl
	 */
	@Override()
	protected void validateEditTabEmpresaOS3(List<ErrorField> errorFields,
			ComunicacionPrl comunicacionPrl) {

		// Datos empresa

		if (!Utilities.getInstance().isEmpty(comunicacionPrl.getTerape())
				&& !Utilities.getInstance()
						.isEmpty(comunicacionPrl.getAnoape())
				&& (comunicacionPrl.getNumape() != null && comunicacionPrl
						.getNumape() != 0)
				&& !Utilities.getInstance()
						.isEmpty(comunicacionPrl.getNumdoc())) {

			ComunicacionApertura comunicacionapertura = new ComunicacionApertura(
					comunicacionPrl.getTerape(), comunicacionPrl.getAnoape(),
					comunicacionPrl.getNumape().longValue());
			comunicacionapertura.setNumdoc056(comunicacionPrl.getNumdoc());

			comunicacionapertura = this.comunicacionAperturaService
					.find(comunicacionapertura);
			if (comunicacionapertura == null) {
				errorFields.add(new ErrorField("datosos3.apertura",
						"error.apertura.invalid"));
			}

		}

		// // codigo centro
		// if (comunicacionPrl.getCodctr() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.detalle.codCentro",
		// "validacion.obligatorio"));
		// }
		// tipo identificacion
		if (comunicacionPrl.getTipdoc() == null) {
			errorFields.add(new ErrorField("comunicacionPrl.tipoidentif",
					"validacion.obligatorio"));
		}
		// numero identificacion
		if (comunicacionPrl.getNumdoc() == null) {
			errorFields.add(new ErrorField("comunicacionPrl.numdoc",
					"validacion.obligatorio"));
		}
		// nombre empresa
		if (comunicacionPrl.getNomemp() == null) {
			errorFields.add(new ErrorField("comunicacionPrl.nombreEmpresa",
					"validacion.obligatorio"));
		}
		// territorio centro
		if (comunicacionPrl.getPrvemp() == null) {
			errorFields.add(new ErrorField(
					"comunicacionPrl.territorioHistorico",
					"validacion.obligatorio"));
		}
		// // municipio
		// if (comunicacionPrl.getMunemp() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.municipio",
		// "validacion.obligatorio"));
		// }
		// // direccion
		// if (comunicacionPrl.getDiremp() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.dirEmpresa",
		// "validacion.obligatorio"));
		// }
		// // codigo postal
		// if (comunicacionPrl.getCpoemp() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.CP",
		// "validacion.obligatorio"));
		// }
		// // telefono
		// if (comunicacionPrl.getTlfemp() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.tlfno",
		// "validacion.obligatorio"));
		// }
		// // total plantilla
		// if (comunicacionPrl.getTrbtot() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.totalPlantilla",
		// "validacion.obligatorio"));
		// }
		// // clase centro
		// if (comunicacionPrl.getClasctr() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.claseCentro",
		// "validacion.obligatorio"));
		// }
		// // fecha eva. riesgos
		// if (comunicacionPrl.getFecevr() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.fecEvr",
		// "validacion.obligatorio"));
		// }
		// // declarante
		// if (comunicacionPrl.getDeclar() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.declarante",
		// "validacion.obligatorio"));
		// }
		// // en calidad de
		// if (comunicacionPrl.getCardec() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.calidadDe",
		// "validacion.obligatorio"));
		// }
	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields
	 *            List<ErrorField>
	 *  comunicacionPrl
	 *            ComunicacionPrl
	 *
	 * @param errorFields the error fields
	 * @param comunicacionPrl the comunicacion prl
	 */
	@Override()
	protected void validateEditTabPrevencionOS2(List<ErrorField> errorFields,
			ComunicacionPrl comunicacionPrl) {

		// if (Utilities.getInstance().isEmpty(comunicacionPrl.getTipmpr1())) {
		// errorFields.add(new ErrorField("comunicacionPrl.modalidad",
		// "validacion.obligatorio"));
		// }
		//
		// if ((Utilities.getInstance().isEmpty(comunicacionPrl.getTipmpr1())
		// || "3".equals(comunicacionPrl.getTipmpr1()))
		// && Utilities.getInstance()
		// .isEmpty(comunicacionPrl.getCodprev1())) {
		// errorFields.add(new ErrorField("comunicacionPrl.empresa",
		// "validacion.obligatorio"));
		// }
		//
		// if (Utilities.getInstance().isEmpty(comunicacionPrl.getNommpr1())) {
		// errorFields.add(new ErrorField("comunicacionPrl.nombre",
		// "validacion.obligatorio"));
		// }
		//
		// if (Utilities.getInstance().isEmpty(comunicacionPrl.getTopseg1())) {
		// errorFields.add(new ErrorField("comunicacionPrl.seguridad",
		// "validacion.obligatorio"));
		// }
		//
		// if (Utilities.getInstance().isEmpty(comunicacionPrl.getTophig1())) {
		// errorFields.add(new ErrorField("comunicacionPrl.higiene",
		// "validacion.obligatorio"));
		// }
		//
		// if (Utilities.getInstance().isEmpty(comunicacionPrl.getToperg1())) {
		// errorFields.add(new ErrorField("comunicacionPrl.ergonomia",
		// "validacion.obligatorio"));
		// }
		//
		// if (Utilities.getInstance().isEmpty(comunicacionPrl.getTopvig1())) {
		// errorFields.add(new ErrorField("comunicacionPrl.vigilancia",
		// "validacion.obligatorio"));
		// }
		//
		// if (Utilities.getInstance().isEmpty(comunicacionPrl.getTiprie1())) {
		// errorFields.add(new ErrorField("comunicacionPrl.modalidad",
		// "validacion.obligatorio"));
		// }
		//
		// if (Utilities.getInstance().isEmpty(comunicacionPrl.getNomrie1())) {
		// errorFields.add(new ErrorField("comunicacionPrl.nombre",
		// "validacion.obligatorio"));
		// }

	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields
	 *            List<ErrorField>
	 *  comunicacionPrl
	 *            ComunicacionPrl
	 *
	 * @param errorFields the error fields
	 * @param comunicacionPrl the comunicacion prl
	 */
	@Override()
	protected void validateEditTabPrevencionOS3(List<ErrorField> errorFields,
			ComunicacionPrl comunicacionPrl) {
		// // riesgos existentes
		// if (comunicacionPrl.getDesrie() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.detalle.riesgos",
		// "validacion.obligatorio"));
		// }
		// // actividad preventiva
		// if (comunicacionPrl.getDesact() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.detalle.actividad",
		// "validacion.obligatorio"));
		// }
	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields
	 *            List<ErrorField>
	 *  comunicacionPrl
	 *            ComunicacionPrl
	 *
	 * @param errorFields the error fields
	 * @param comunicacionPrl the comunicacion prl
	 */
	@Override()
	protected void validateEditTabNotificacion(List<ErrorField> errorFields,
			ComunicacionPrl comunicacionPrl) {

		// descripcion maquinaria
		if (comunicacionPrl.getDatosNotificacion() != null) {

			DatosNotificacion datosNotificacion = comunicacionPrl
					.getDatosNotificacion();

			if (datosNotificacion.getIdioma066() == null) {
				errorFields.add(new ErrorField("idioma",
						"validacion.obligatorio"));
			}

			DatosAviso datosAvisoFind = new DatosAviso();
			datosAvisoFind.setDatosNotificacion(datosNotificacion);
			List<DatosAviso> listaDatosAviso = this.datosAvisoService.findAll(
					datosAvisoFind, null);
			if (listaDatosAviso == null || listaDatosAviso.isEmpty()) {
				errorFields.add(new ErrorField("aperturas.detalle.datosAviso",
						"error.ningunDatoAviso"));
			}

			if (datosNotificacion.getCanalnotif066() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.canalNotif",
						"validacion.obligatorio"));
			} else if (Constantes.CANAL_NOTIF_POSTAL.equals(datosNotificacion
					.getCanalnotif066())) {
				if (datosNotificacion.getDatosLocalizacion() == null) {
					errorFields.add(new ErrorField("canalNotif.postal",
							"error.ningunDatoLocalizacion"));
				} else {
					DatosLocalizacion datosLocalizacion = datosNotificacion
							.getDatosLocalizacion();

					if (datosLocalizacion.getProvincia() == null
							|| datosLocalizacion.getProvincia()
									.getCodProvincia() == null) {
						errorFields.add(new ErrorField("aperturas.territorio",
								"validacion.obligatorio"));
					}

					if (datosLocalizacion.getMunicipio() == null
							|| datosLocalizacion.getMunicipio()
									.getCodMunicipio() == null) {
						errorFields.add(new ErrorField("aperturas.municipio",
								"validacion.obligatorio"));
					}

					if (datosLocalizacion.getLocalidad() == null
							|| datosLocalizacion.getLocalidad()
									.getCodLocalidad() == null) {
						errorFields.add(new ErrorField(
								"aperturas.detalle.localidad",
								"validacion.obligatorio"));
					}

					if (datosLocalizacion.getCalle067() == null) {
						errorFields.add(new ErrorField(
								"aperturas.detalle.calle",
								"validacion.obligatorio"));
					}
					if (datosLocalizacion.getCodpostal067() == null) {
						errorFields.add(new ErrorField("aperturas.detalle.cp",
								"validacion.obligatorio"));
					}
					
					if(datosLocalizacion.getLocalidad()!=null && datosLocalizacion.getLocalidad().getCodLocalidad() != null
							&& datosLocalizacion.getCodpostal067()!=null){
						this.validateLocalidadCP(errorFields, comunicacionPrl);
					}
				}
			}

		}

	}
	
	/**
	 * Valida que el CP pertenezca a la localidad
	 * 
	 *  errorFields
	 *            List<ErrorField>
	 *  comunicacionPrl
	 *            ComunicacionPrl
	 *
	 * @param errorFields the error fields
	 * @param comunicacionPrl the comunicacion prl
	 */
	@Override()
	protected void validateLocalidadCP(List<ErrorField> errorFields,
			ComunicacionPrl comunicacionPrl) {

		if(!this.comunicionPrlService.validaLocalidadCP(comunicacionPrl)){
			errorFields.add(new ErrorField("aperturas.detalle.cp",
				"error.cp.localidad"));
		}
	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields
	 *            List<ErrorField>
	 *  comunicacionPrl
	 *            ComunicacionPrl
	 *
	 * @param errorFields the error fields
	 * @param comunicacionPrl the comunicacion prl
	 */
	@Override()
	protected void validateEditTabEmpresaOS2(List<ErrorField> errorFields,
			ComunicacionPrl comunicacionPrl) {

		// Datos empresa

		if (!Utilities.getInstance().isEmpty(comunicacionPrl.getTerape())
				&& !Utilities.getInstance()
						.isEmpty(comunicacionPrl.getAnoape())
				&& (comunicacionPrl.getNumape() != null && comunicacionPrl
						.getNumape() != 0)
				&& !Utilities.getInstance()
						.isEmpty(comunicacionPrl.getNumdoc())) {

			ComunicacionApertura comunicacionapertura = new ComunicacionApertura(
					comunicacionPrl.getTerape(), comunicacionPrl.getAnoape(),
					comunicacionPrl.getNumape().longValue());
			comunicacionapertura.setNumdoc056(comunicacionPrl.getNumdoc());

			comunicacionapertura = this.comunicacionAperturaService
					.find(comunicacionapertura);
			if (comunicacionapertura == null) {
				errorFields.add(new ErrorField("datosos2.apertura",
						"error.apertura.invalid"));
			}

		}

		// // codigo centro
		// if (comunicacionPrl.getCodctr() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.detalle.codCentro",
		// "validacion.obligatorio"));
		// }
		// tipo identificacion
		if (comunicacionPrl.getTipdoc() == null) {
			errorFields.add(new ErrorField("comunicacionPrl.tipoidentif",
					"validacion.obligatorio"));
		}
		// numero identificacion
		if (comunicacionPrl.getNumdoc() == null) {
			errorFields.add(new ErrorField("comunicacionPrl.numdoc",
					"validacion.obligatorio"));
		}
		// nombre empresa
		if (comunicacionPrl.getNomemp() == null) {
			errorFields.add(new ErrorField("comunicacionPrl.nombreEmpresa",
					"validacion.obligatorio"));
		}
		// // cnae empresa
		// if (comunicacionPrl.getCnaeemp() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.cnaeEmp",
		// "validacion.obligatorio"));
		// }
		// trabajo anexo
		if (comunicacionPrl.getIndanx() != null
				&& comunicacionPrl.getIndanx().equals(Constantes.VALUE_SI)
				&& comunicacionPrl.getApdoanx() == null) {
			errorFields.add(new ErrorField("comunicacionPrl.trabajoAnexoI",
					"validacion.obligatorio"));
		}
		// // pais
		// if (comunicacionPrl.getPaisemp() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.pais",
		// "validacion.obligatorio"));
		// }
		// if (comunicacionPrl.getPaisemp() == null
		// || (comunicacionPrl.getPaisemp() != null && comunicacionPrl
		// .getPaisemp().equals(Constantes.ID_PAIS_ESPANA))) {
		// // territorio empresa
		// if (comunicacionPrl.getPrvemp() == null) {
		// errorFields.add(
		// new ErrorField("comunicacionPrl.territorioHistorico",
		// "validacion.obligatorio"));
		// }
		// // municipio
		// if (comunicacionPrl.getMunemp() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.municipio",
		// "validacion.obligatorio"));
		// }
		// }
		// // direccion
		// if (comunicacionPrl.getDiremp() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.dirEmpresa",
		// "validacion.obligatorio"));
		// }
		// // codigo postal
		// if (comunicacionPrl.getCpoemp() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.CP",
		// "validacion.obligatorio"));
		// }
		// // telefono
		// if (comunicacionPrl.getTlfemp() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.tlfno",
		// "validacion.obligatorio"));
		// }
		// // total plantilla
		// if (comunicacionPrl.getTrbtot() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.totalPlantilla",
		// "validacion.obligatorio"));
		// }
		// territorio centro
		if (comunicacionPrl.getPrvctr() == null) {
			errorFields.add(new ErrorField(
					"comunicacionPrl.territorioHistorico",
					"validacion.obligatorio"));
		}
		// // municipio centro
		// if (comunicacionPrl.getMunctr() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.municipio",
		// "validacion.obligatorio"));
		// }
		// // direccion centro
		// if (comunicacionPrl.getDirctr() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.dirEmpresa",
		// "validacion.obligatorio"));
		// }
		// // codigo postal centro
		// if (comunicacionPrl.getCpoctr() == null) {
		// errorFields.add(new ErrorField("comunicacionPrl.CP",
		// "validacion.obligatorio"));
		// }
	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields
	 *            List<ErrorField>
	 *  comunicacionPrl
	 *            ComunicacionPrl
	 *
	 * @param errorFields the error fields
	 * @param comunicacionPrl the comunicacion prl
	 */
	@Override()
	protected void validateEditTabAuditoria(List<ErrorField> errorFields,
			ComunicacionPrl comunicacionPrl) {

		if (Constantes.VALUE_SI.equals(comunicacionPrl.getIndaud())) {
			// fecha auditoria
			if (comunicacionPrl.getFecaud() == null) {
				errorFields.add(new ErrorField("comunicacionPrl.fecAuditoria",
						"validacion.obligatorio"));
			}
			// empresa auditora
			if (comunicacionPrl.getCodempaud() == null) {
				errorFields.add(new ErrorField(
						"comunicacionPrl.empresaAuditora",
						"validacion.obligatorio"));
			}
			// nombre empresa auditora
			if (comunicacionPrl.getEmpaud() == null) {
				errorFields.add(new ErrorField(
						"comunicacionPrl.nombreEmpAuditora",
						"validacion.obligatorio"));
			}
		}
	}

}